<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Events;
use Inside\Host\Bridge\BridgeContent;

class AddFieldsToContentTypeEvents extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('events', 'participants_number', [
            'name' => 'participants_number',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Nombre de participants',
            ],
            'description' => [
                'fr' => 'Le nombre maximum d\'utilisateurs pouvant participer à cet événement',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('events', 'registration_enabled', [
            'name' => 'registration_enabled',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Afficher les heures',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ]);

        $bridgeContent = new BridgeContent();

        Events::pluck('uuid')->each(fn (string $uuid) => $bridgeContent->contentUpdate('events', ['uuid' => $uuid, 'registration_enabled' => false]));
    }
}
