<?php

use Illuminate\Support\Collection;
use Inside\Content\Models\Contents\Users;

return [
    'sync_attributes' => [
        'mail' => 'userPrincipalName',
        'name' => 'userPrincipalName',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'function' => 'extension_ff66565539024304bdf51c7c456b4411_title',
        'address' => 'streetAddress',
        'zip_code' => 'postalCode',
        'phone' => fn (mixed $user) => $user->businessPhones[0] ?? "",
        'mobile_phone' => 'mobilePhone',
        'directions' => fn (mixed $user) => reference('directions')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user->department)))
            ->get(),
        'departments' => fn (mixed $user) => reference('departments')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user->onPremisesExtensionAttributes->extensionAttribute3)))
            ->get(),
        'teams' => fn (mixed $user) => reference('teams')
          ->identifiedBy('code')
          ->from(trim($user->onPremisesExtensionAttributes->extensionAttribute2))
          ->get(),
        'services' => fn (mixed $user) => reference('services')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user->extension_ff66565539024304bdf51c7c456b4411_division)))
            ->get(),
        'registration_number' => 'extension_ff66565539024304bdf51c7c456b4411_wWWHomePage',
        'users' => fn (mixed $user) => reference('users')
            ->identifiedBy('email')
            ->from($user->manager)
            ->withoutCreation()
            ->first(),
        'status' => fn () => 1,
        'is_maintenance' => 'isMaintenance',
    ],
    'custom_attributes' => [
        'manager' => 'userPrincipalName',
    ],
    'postfilter' => function (Collection $users) {
        $maintenances = Users::all()->where('is_maintenance', true)->pluck('email');

        return $users->map(function ($user) use ($maintenances) {
            $user->isMaintenance = $maintenances->contains($user->userPrincipalName);

            return $user;
        });
    },
];
