import SpacePage from '../pages/spaces/SpacePage'
import TabSpacePage from '../pages/spaces/TabSpacePage'
import SimpleSpacePage from '../pages/spaces/SimpleSpacePage'

import { fetchSpace, fetchSimpleSpace } from '../components/spaces/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/directory/DirectoryPage')
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace),
    path: '/espaces/:slug'
  },
  {
    name: 'TabSpacePage',
    component: withFetch(TabSpacePage, { size: 'xxl', watch: true })(
      fetchSpace
    ),
    path: '/espaces/:slug/page'
  },
  {
    name: 'SimpleSpacePage',
    component: withFetch(SimpleSpacePage, { size: 'xxl', watch: true })(
      fetchSimpleSpace
    ),
    path: '/espaces-simples/:slug'
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'WallsListingPage',
    meta: { disabled: false, customSlug: 'walls' }
  },
  {
    name: 'WallPage',
    meta: { disabled: false }
  }
]
