import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: spaceCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            'slug',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'TabSpacePage',
        params: {
          slug: spaceCategories[0].spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spaceCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'TabSpacePage',
        params: {
          slug: spaceCategories[0].spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'TabSpacePage',
          params: {
            slug: pagesCategories[0].spaces.slug[0]
          }
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'slug',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'TabSpacePage',
        params: {
          slug: spacesPages[0].pages_categories.spaces.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'TabSpacePage',
        params: {
          slug: spacesPages[0].pages_categories.spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'TabSpacePage',
          params: {
            slug: spacesPages[0].pages_categories.spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  tabsSpaces: {
    add: ({ data }) => ({
      name: 'SimpleSpacePage',
      params: { slug: data.slug[0] }
    })
  },
  tabs: {
    add: async ({ data }) => {
      const { data: spaceCategories } = await http.get('content/tabs', {
        fields: [
          'uuid',
          'slug',
          {
            tabs_spaces: {
              fields: ['uuid', 'title', 'slug']
            }
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'SimpleSpacePage',
        params: {
          slug: spaceCategories[0].tabs_spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spaceCategories } = await http.get('content/tabs', {
        fields: [
          'uuid',
          {
            tabs_spaces: {
              fields: ['uuid', 'title', 'slug']
            }
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'SimpleSpacePage',
        params: {
          slug: spaceCategories[0].tabs_spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get('content/tabs', {
        fields: ['uuid', { tabs_spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SimpleSpacePage',
          params: {
            slug: pagesCategories[0].tabs_spaces.slug[0]
          }
        }
      }
    }
  },
  tabsPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/tabs_pages', {
        fields: [
          'uuid',
          'slug',
          {
            tabs: [
              'uuid',
              'title',
              {
                tabs_spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'SimpleSpacePage',
        params: {
          slug: spacesPages[0].tabs.tabs_spaces.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/tabs_pages', {
        fields: [
          'uuid',
          'title',
          {
            tabs: [
              'uuid',
              'title',
              {
                simple_spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'SimpleSpacePage',
        params: {
          slug: spacesPages[0].tabs.tabs_spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/tabs_pages', {
        fields: [
          'uuid',
          'title',
          {
            tabs: [
              'uuid',
              'title',
              {
                tabs_spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SimpleSpacePage',
          params: {
            slug: spacesPages[0].tabs.tabs_spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  }
}
