import { http } from '@inside-library/helpers/Http'

const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type',
        'slug',
        'presentation',
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'function',
              'phone',
              'mobile_phone'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          tools: {
            fields: [
              'title',
              'uuid',
              'has_section',
              'tools_link',
              'admin',
              'image',
              'class',
              'content_type',
              'icon'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          documents: {
            fields: [
              'uuid',
              'title',
              'file',
              'has_section',
              'admin',
              'content_type',
              'published_at'
            ],
            filters: { 'status:eq': 1 }
          }
        },
        {
          news: {
            fields: [
              'uuid',
              'title',
              'slug',
              'introduction',
              'published_at',
              'image',
              'chapo',
              'content_type',
              { news_categories: ['uuid', 'title'] },
              { reactions: ['count', { users: ['uuid'] }] },
              { comments: ['count'] }
            ],
            filters: {
              'status:eq': 1,
              'published_at:lte': 'now()',
              limit: 1
            }
          }
        },
        {
          pages_categories: { fields: ['count'], filters: { reverse: true } }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchSimpleSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/tabs_spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'color',
        'published_at',
        'introduction',
        'admin',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchSpace, fetchSimpleSpace }
