<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Spaces;
use Inside\Content\Models\Contents\News;

class ModifyNewsCategoriesRef extends Migration
{
    public function up(): void
    {
        $contentTypeBridge = new BridgeContentType();

        $contentTypeBridge->contentTypeCreateOrUpdateField(
            'spaces',
            'news',
            [
                'name' => 'news',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => true,
                'weight' => 5,
                'title' => [
                    'fr' => 'Actualité',
                ],
                'description' => [
                    'fr' => 'Sélectionnez l\'actualité reférence.',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['news'],
                    'cardinality' => 1,
                ],
                'selectable_all' => false,
            ]
        );

        Artisan::call("models:rebuild");

        Spaces::whereHas('newsCategories')->each(function ($space) {
            $latestNews = News::whereHas(
                'newsCategories',
                fn ($query) =>
                $query->where('uuid', $space->newsCategories->first()->uuid)
            )->latest()->first();

            if (!$latestNews) {
                return;
            }

            $bridge = new BridgeContent();

            $bridge->contentUpdate('spaces', ['uuid' => $space->uuid, 'news' => $latestNews->uuid]);
        });

        $contentTypeBridge->contentTypeDeleteField('node', 'spaces', 'news_categories');
    }
}
