<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class SetUsersDefaultTools extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContent();
        $bridgeContent = new BridgeContentType();

        $defaultTools = Tools::query()->orderBy('title')->get();

        $bridgeContent->contentTypeCreateOrUpdateField('users', 'tools', [
            'default' => $defaultTools->map(fn (Tools $tool) => ['target_uuid' => $tool->uuid_host])->all(),
        ]);

        Users::each(fn (Users $users) => $bridge->contentUpdate('users', [
            'uuid' => $users->uuid,
            'tools' => $defaultTools->pluck('uuid')->all()
        ]));

        $this->finishUp();
    }
}
