<?php

declare(strict_types=1);

namespace Inside\SCJE\Providers;

use Inside\Kernel\Authentication\SingleSignOnProviderEnum;
use Inside\Kernel\Authentication\Facades\SingleSingOnRedirection;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

final class ServiceProvider extends BaseServiceProvider
{
    public function register(): void
    {
        SingleSingOnRedirection::setProvider(SingleSignOnProviderEnum::SAML)->enable();

        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeConfigTo(__DIR__.'/../../config/authentication.php', 'authentication');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
