<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddLinkTeamsFieldToUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateField(
            'users',
            'link_teams',
            [
                'name' => 'link_teams',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Teams',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            4
        );
    }

    public function down(): void
    {
    }
}
