<?php

use Illuminate\Support\Arr;
use Illuminate\Support\Collection;

return [
    'postfilter' => function (Collection $users): Collection {
        return $users->filter(fn (mixed $user) => $user->accountEnabled);
    },
    'sync_attributes' => [
        'email' => 'mail',
        'name' => 'mail',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'function' => 'jobTitle',
        'mobile_phone' => 'mobilePhone',
        'link_teams' => fn (mixed $user) => "https://teams.microsoft.com/l/chat/0/0?users=$user->userPrincipalName",
        'phone' => fn (mixed $user) => Arr::first($user->businessPhones),
        'locations' => fn (mixed $user) => reference('locations')->identifiedBy('code')->from($user->department)->get(),
        'birthday' => fn (mixed $user) => $user->state
            ? carbonize('d/m/Y')->from($user->state)->birthday()
            : null,
    ],
];
