import SpacePage from '../pages/spaces/SpacePage'
import TabSpacePage from '../pages/spaces/TabSpacePage'
import { fetchSpacePage, fetchTabSpacePage } from '../components/spaces'

import SimpleSpacePage from '../pages/simpleSpace/SimpleSpacePage'
import { fetchSimpleSpace } from '../components/simpleSpace'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: {
      component: 'minimal'
    }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      dateKey: 'updated_at'
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/DirectoryPage')
  },
  {
    name: 'SpacePage',
    path: '/espaces/:slug',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(
      fetchSpacePage
    )
  },
  {
    name: 'TabSpacePage',
    path: '/espaces/:slug/pages',
    component: withFetch(TabSpacePage, { size: 'xxl', watch: true })(
      fetchTabSpacePage
    )
  },
  {
    name: 'MapPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'SimpleSpacePage',
    path: '/les-espaces/:slug/pages',
    component: withFetch(SimpleSpacePage, { size: 'xxl', watch: true })(
      fetchSimpleSpace
    )
  },
  {
    name: 'OffersListing',
    path: '/petites-annonces',
    component: () => import('../pages/offers/OffersListingPage')
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
