import { markRaw } from 'vue'

import { BaseText } from 'inside-collection/atoms'

import RatioImageUi from '@inside-ui/RatioImageUI'

export default {
  components: { RatioImageUi, BaseText },
  props: {
    content_type: {
      type: String
    }
  },
  data() {
    return {
      m_categoriesConfig: {
        offers_categories: {
          data: (data, contentType, { getData }) => {
            return getData(data, contentType)
          },
          style: 'tag',
          disabledOn: ['OffersListing', 'OfferPage'],
          href: item => ({
            name: 'OffersListing',
            query: { offers_categories: item.uuid }
          })
        },
        localisations: {
          data: (data, contentType, { getData }) => {
            return getData(data, contentType)
          },
          disabledOn: ['OffersListing', 'OfferPage'],
          href: item => ({
            name: 'OffersListing',
            query: { localisations: item.uuid }
          })
        }
      }
    }
  },
  methods: {
    m_capsuleOverrides(data, { replaceItem, deleteItems }) {
      deleteItems('bookmarks')

      if (!data.image) {
        replaceItem('link', {
          id: 'link',
          tag: 'router-link',
          class: 'main-image',
          ...(data.offers_categories.data[0].image && {
            children: [
              {
                id: 'image',
                tag: markRaw(RatioImageUi),
                data: {
                  src: this.$_getContentImage(
                    data.offers_categories.data[0].image,
                    'image-card'
                  )
                }
              }
            ]
          })
        })
      }
    },
    m_fullOverrides(data, { deleteItems }) {
      deleteItems(
        'bottom-actions',
        'bookmarks',
        'likes',
        'statistics',
        'comments',
        'print'
      )
    }
  }
}
