import { http } from '@inside-library/helpers/Http'

const fetchSpacePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      filters: { slug: $route.params.slug, 'status:eq': 1 },
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'space_introduction',
        'image',
        'admin',
        'custom_slug',
        'presentation',
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'phone',
              { departments: ['uuid', 'title'] },
              { functions: ['uuid', 'title'] }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          tools: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'admin',
              'icon',
              'image',
              'tools_link',
              'content'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'chapo',
                    'published_at',
                    'image',
                    'content_type',
                    { news_categories: ['uuid', 'title'] },
                    { reactions: ['count', { users: ['uuid'] }] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    'published_at:lte': 'now()',
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'published_at:lte': 'now()'
            }
          }
        }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchTabSpacePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'image',
        'space_introduction'
      ],
      filters: { 'slug:eq': $route.params.slug, 'status:eq': 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
export { fetchTabSpacePage, fetchSpacePage }
