import { http } from '@inside-library/helpers/Http'

const fetchSimpleSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/simplified_spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'introduction',
        'admin',
        'content_type',
        'slug'
      ],
      filters: {
        'status:eq': 1,
        sort: 'title:asc',
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchSimpleSpace }
