import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  simplifiedSpaces: {
    add: ({ data }) => ({
      name: 'SimpleSpacePage',
      params: { slug: data.slug[0] }
    })
  },
  groupingPages: {
    fields: ['uuid', { spaces: ['slug'] }, { simplified_spaces: ['slug'] }],
    add: ({ data }) => {
      return {
        name: data.spaces ? 'SpacePage' : 'SimpleSpacePage',
        params: {
          slug: data.spaces
            ? data.spaces.slug[0]
            : data.simplified_spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/grouping_pages', {
          fields: [{ spaces: ['slug'] }, { simplified_spaces: ['slug'] }],
          filters: { 'uuid:eq': uuid }
        })

        return {
          name: data[0].spaces ? 'SpacePage' : 'SimpleSpacePage',
          params: {
            slug: data[0].spaces
              ? data[0].spaces.slug[0]
              : data[0].simplified_spaces.slug[0]
          }
        }
      } catch (err) {
        return '/'
      }
    }
  },
  spacePages: {
    add: async ({ data }) => {
      try {
        const { data: dataGroupingPages } = await http.get(
          'content/space_pages',
          {
            fields: [
              {
                grouping_pages: {
                  fields: ['uuid', 'title', 'slug'],
                  filters: { 'status:eq': 1 }
                }
              }
            ],
            filters: { 'uuid:eq': data.uuid }
          }
        )

        const uuidGroupingPages = dataGroupingPages[0].grouping_pages.uuid

        const { data: groupingPages } = await http.get(
          'content/grouping_pages',
          {
            fields: [{ spaces: ['slug'] }, { simplified_spaces: ['slug'] }],
            filters: { 'uuid:eq': uuidGroupingPages }
          }
        )

        return {
          name: groupingPages[0].spaces ? 'TabSpacePage' : 'SimpleSpacePage',
          params: {
            slug: groupingPages[0].spaces
              ? groupingPages[0].spaces.slug[0]
              : groupingPages[0].simplified_spaces.slug[0]
          },
          query: {
            page: data.uuid
          }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data: dataGroupinPages } = await http.get(
          'content/space_pages',
          {
            fields: [
              {
                grouping_pages: {
                  fields: ['uuid', 'title', 'slug'],
                  filters: { 'status:eq': 1 }
                }
              }
            ],
            filters: { 'uuid:eq': uuid }
          }
        )

        const uuidGroupingPages = dataGroupinPages[0].grouping_pages.uuid

        const { data: groupingPages } = await http.get(
          'content/grouping_pages',
          {
            fields: [{ spaces: ['slug'] }, { simplified_spaces: ['slug'] }],
            filters: { 'uuid:eq': uuidGroupingPages }
          }
        )

        return {
          name: groupingPages[0].spaces ? 'SpacePage' : 'SimpleSpacePage',
          params: {
            slug: groupingPages[0].spaces
              ? groupingPages[0].spaces.slug[0]
              : groupingPages[0].simplified_spaces.slug[0]
          }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  offers: {
    add: () => ({ name: 'OffersListing' }),
    delete: () => ({ name: 'OffersListing' })
  },
  offersCategories: {
    add: () => ({ name: 'OffersListing' }),
    delete: () => ({ name: 'OffersListing' })
  },
  localisations: {
    add: () => ({ name: 'OffersListing' }),
    delete: () => ({ name: 'OffersListing' })
  }
}
