export default {
  'inside-auth': {
    loginForm: {
      userId: {
        modelName: 'name',
        inputType: 'text'
      }
    }
  },
  'inside-events': {
    bookmarkEnabled: true,
    showBookmarks: true,
    paragraphs: {
      fetchedContents: {
        displayAttributes: ({ item }) => ({
          to: {
            name: 'EventPage',
            params: {
              slug: item.slug[0]
            }
          }
        })
      }
    }
  },
  'inside-maps': {
    rootRoute: {
      fr: 'les-equipements-de-la-ville'
    },
    modalName: 'implantations'
  },
  'inside-news': {
    paragraphs: {
      fetchedContents: {
        displayAttributes: ({ item }) => ({
          to: {
            name: 'NewsPage',
            params: {
              slug: item.slug[0]
            }
          }
        })
      }
    }
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true,
      useBackgroundImage: true
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'notifications', restrictions: [], icon: 'settings' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'contents', restrictions: [] }
      ]
    },
    shortcuts: {
      max: 5
    }
  }
}
