import { http } from '@inside-library/helpers/Http'

const fetchNewsSlider = async () => {
  try {
    const { data } = await http.get('content/news', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'chapo',
        'slug',
        'content_type',
        'is_featured',
        { reactions: ['count', { users: ['uuid'] }] },
        {
          news_categories: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': 1 }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'is_featured:eq': 1,
        sort: 'published_at:desc',
        limit: 4
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchExternalNewsListing = async () => {
  try {
    const data = await http.get('rss?flux=https://www.sceaux.fr/news/rss', {
      fields: [
        'title',
        'link',
        'description',
        'category',
        'comments',
        'pubDate',
        { enclosure: '@url' }
      ],
      filters: {
        limit: 3
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchExternalEventsListing = async () => {
  try {
    const data = await http.get(
      'rss?flux=https://www.sceaux.fr/agenda/rss.xml',
      {
        fields: ['title', 'link', 'description', 'category', 'pubDate'],
        filters: {
          limit: 3
        }
      }
    )

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchNewsSlider, fetchExternalNewsListing, fetchExternalEventsListing }
