<?php

namespace Inside\SCEA\Console;

use Illuminate\Console\Command;
use Inside\Host\Bridge\BridgeContent;
use Inside\SCEA\Facades\CsvImporter;
use Inside\Content\Models\Contents\Users;

class UserConsolidationCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'scea:user:import';

    /**
     * @var string
     */
    protected $signature = 'scea:user:import { --P|path=}';

    /**
     * @var string
     */
    protected $description = 'Import de consolidation des utilisateurs';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    private function importUsers(array $users): void
    {
        $bridge = new BridgeContent();

        foreach ($users as $user) {
            $original = Users::query()->where('name', trim($user['samaccountname']))->first();
            if (!$original) {
                continue;
            }
            $data = [
                'uuid' => $original->uuid,
                'name' => trim($user['samaccountname']),
                'email' => trim($user['mail']),
                'lastname' => trim($user['nom d\'usage ou marital']),
                'firstname' => trim($user['prénom']),
                'function' => trim($user['poste']),
                'departments' => CsvImporter::getReference($user, $bridge, 'departments', 'direction ou pôle'),
                'services' => CsvImporter::getReference($user, $bridge, 'services', 'service')
            ];
            $bridge->contentUpdate('users', $data);
        }
    }

    public function handle(): void
    {
        $filePath = __DIR__ . '/../../../../../' . env('USER_IMPORT_PATH', 'imports/users.csv');
        $path = $this->option('path');

        if ($path) {
            $filePath = $path;
        }

        $users = CsvImporter::getRecords($filePath, ',');
        $this->importUsers($users);
    }
}
