<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Functions;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateFunctionsContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('functions');

        $this->getBridge()?->contentTypeDeleteField('user', 'user', 'function');
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'functions',
            options: [
                'name' => 'functions',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'editable' => true,
                'title' => [
                    'fr' => 'Fonction',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['functions'],
                    'cardinality' => 1,
                ],
            ],
            weight: 5
        );

        Artisan::call('models:rebuild');

        $defaultFunctions = [
            "Acheteur",
            "Adjoint au chef de service",
            "Adjoint au directeur",
            "Adjoint d'animation",
            "Administrateur systèmes et réseaux",
            "Afficheur",
            "Agent d'accueil",
            "Agent de dévt des NTIC",
            "Agent de propreté voirie",
            "Agent d'entretien",
            "Agent de restauration et d'entretien",
            "Agent équipe polyvalente",
            "Agent polyvalent",
            "Agent social chargé d'animation",
            "Aide serrurier menuisier",
            "Aide soignante",
            "Animateur",
            "Appariteur",
            "Assistant",
            "Assistante",
            "Assistant comptable",
            "Assistante comptable",
            "Assistant de direction",
            "Assistante de direction",
            "ATSEM",
            "Auxiliaire de petite enfance",
            "AuxilIaire de puériculture",
            "AuxilIaire de soins",
            "Chargé d'accueil",
            "Chargé de communication",
            "Chargé de développement santé",
            "Chargé de gestion budgétaire et comptable",
            "Chargé de mission",
            "Chargé de prévention jeunesse",
            "Chargé des affaires foncières",
            "Chargé des moyens généraux",
            "Chargé du recrutement",
            "Chauffeur",
            "Chef de la section adulte",
            "Chef de la section image et son",
            "Chef de la section jeunesse",
            "Chef de la section scientifique et numérique",
            "Chef de projet",
            "Chef de secteur",
            "Chef de service",
            "Chef d'équipe",
            "Conducteur de transport en commun",
            "Conseiller en économie sociale et familiale",
            "Conseiller prévention",
            "Coordonnateur gérontologique",
            "Cuisinier",
            "Directeur",
            "Directeur de pôle",
            "Directeur d’accueil de loisirs",
            "Directeur général des services",
            "Directeur général adjoint des services",
            "Directeur résidence autonomie",
            "Educateur de jeunes enfants",
            "Educateur sportif",
            "Electricien",
            "Evaluateur gérontologique",
            "Garde urbain",
            "Gardien de cimetière",
            "Gestionnaire administratif et budgétaire",
            "Agent d'entretien et de surveillance",
            "Gardien RPA",
            "Gestionnaire",
            "Gestionnaire comptable",
            "Graphiste",
            "Infirmier SSIAD",
            "Ingénieur projets bâtiments",
            "Instructeur droits des sols",
            "Intendant de l'Hôtel de ville",
            "Intendant des salles externes",
            "Jardinier",
            "Juriste",
            "Lingère",
            "Menuisier",
            "Peintre",
            "Plombier",
            "Policier municipal",
            "Projectionniste",
            "Référent",
            "Référent d’accueil de loisirs",
            "Régisseur",
            "Responsable d'office",
            "Responsable RAM/RAP",
            "Secrétaire",
            "Serrurier",
            "Technicien informatique et téléphonie",
            "Technicien maintenance",
            "Technicien travaux",
        ];

        $bridgeContent = new BridgeContent();
        foreach ($defaultFunctions as $function) {
            $uuid = Functions::where('title', $function)->first()?->uuid;

            $bridgeContent->contentInsert(
                type: 'functions',
                data: array_filter([
                    'title' => $function,
                    'uuid' => $uuid,
                ]),
                creation: $uuid === null,
            );
        }

        $this->finishUp();
    }
}
