<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class RemoveShowFieldOnTools extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        $bridge->updateFieldOptions('tools', 'tools_categories', ['required' => false]);

        $tools = Tools::query()->where('show', 1)->get();

        foreach ($tools as $tool) {
            $bridgeContent->contentUpdate('tools', [
                'uuid' => $tool->uuid,
                'tools_categories' => null
            ]);
        }

        $bridge->contentTypeDeleteField('node', 'tools', 'show');
    }

    public function down(): void
    {
    }
}
