<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'space_pages',
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Page d\'espace',
        ],
    ],
    'fields' => [
        [
            'name' => 'grouping_pages',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Regroupement de pages',
            ],
            'description' => [
                'fr' => 'Choisissez le regroupement dans laquelle cette page doit remonter',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['grouping_pages'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
