<?php

return [
    'types'  => [
        'news'      => [
            'category' => 'news_categories',
            'comments' => false,
            'likes'    => false,
        ],
        'events'    => [
            'category' => 'events_categories',
            'comments' => false,
            'likes'    => true,
        ],
        'documents' => [
            'category' => 'folders',
            'comments' => false,
            'likes'    => false,
        ],
        'space_pages'    => [
            'category' => 'grouping_pages',
            'comments' => false,
            'likes'    => false,
        ],
        'simplified_spaces'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'pages'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'offers'    => [
            'category' => 'offers_categories',
            'comments' => false,
            'likes'    => false,
        ],
        'forms'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
    ],
    'export' => [
        'contents'       => [
            'headers'    => [
                'uuid'         => 'UUID',
                'content_type' => 'Content type',
                'title'        => 'Title',
                'edit'         => 'Edit link',
            ],
            'presenters' => [
                'edit' => function ($value, $model) {
                    return env('APP_URL').'/edit/'.class_to_type($model).'/'.$model->uuid;
                },
            ],
        ],
        'users'          => [
            'headers' => [
                'email'     => 'Mail address',
                'full_name' => 'Full name',
            ],
        ],
        'user_visits' => [
            'headers'    => [],
        ],
        'authentication' => [
            'headers' => [],
        ],
    ],
];
