<?php

use Inside\Host\Bridge\BridgeContent;

return [
    'usernames' => [
        'ldap' => [
            'discover' => env('ADLDAP_LDAP_DISCOVER', 'mail'),
            'authenticate' => env('ADLDAP_LDAP_AUTHENTICATE', 'mail'),
        ],
        'eloquent' => env('ADLDAP_ELOQUENT_VALUE', 'email'),
    ],
    'discovering_attributes' => 'name',
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'samaccountname',
        'lastname' => 'sn',
        'firstname' => 'givenname',
        'is_maintenance' => function ($user, BridgeContent $bridge) {
            return false;
        }
    ],
];
