<?php

namespace Inside\SCEA\Services;

use Inside\Host\Bridge\BridgeContent;
use League\Csv\Reader;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;

/**
 * Class CsvImportService
 *
 * @package Inside\SCEA\src\Services
 */
class CsvImportService
{
    /**
     * @param string $path
     * @return array
     */
    public function getRecords(string $path, string $delimiter = ";"): array
    {
        if (!file_exists($path)) {
            throw new \Exception('file not found');
        }
        $csv = Reader::createFromPath($path, 'r');

        $encoding = mb_detect_encoding($csv->getContent(), mb_list_encodings(), true);

        if ($encoding !== 'UTF-8') {
            $csv->setOutputBOM(Reader::BOM_UTF8);
            $csv->addStreamFilter('convert.iconv.'.$encoding.'/UTF-8');
        }

        $csv->setDelimiter($delimiter);
        $csv->setHeaderOffset(0);

        $headers = array_map(
            function ($item) {
                return trim(strtolower($item));
            },
            $csv->getHeader()
        );

        return iterator_to_array($csv->getRecords($headers));
    }

    public function getReference(array $record, BridgeContent $bridge, string $bundle, string $column): ?array
    {
        $name = trim(ucfirst(strtolower($record[$column])));

        if (empty($name)) {
            return null;
        }

        $query = call_user_func('Inside\\Content\\Models\\Contents\\' . Str::studly($bundle) . '::query');

        $entity = $query->where('title', $name)->first();
        if ($entity) {
            return [$entity->uuid];
        }

        $uuid = $bridge->contentInsert($bundle, [
            'title' => $name,
            'type' => 'node',
            'bundle' => $bundle
        ]);

        if ($uuid) {
            return [$uuid];
        }
        return null;
    }
}
