<?php

namespace Inside\SCEA\Providers;

use Illuminate\Container\Container;
use Inside\SCEA\Console\ImportEquipmentsLocationsCommand;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Inside\SCEA\Console\UserConsolidationCommand;
use Inside\SCEA\Services\CsvImportService;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * SCEA Service provider.
 *
 * @category Class
 * @package  Inside\SCEA\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    protected array $commands = [
        ImportEquipmentsLocationsCommand::class,
        UserConsolidationCommand::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__ . '/../../config/ldap_auth.php', 'ldap_auth');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/import.php', 'import');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeConfigTo(__DIR__.'/../../config/feed.php', 'feed');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
