<?php

namespace Inside\SCEA\Console;

use Illuminate\Console\Command;
use Inside\Host\Bridge\BridgeContent;
use Inside\SCEA\Facades\CsvImporter;

class ImportEquipmentsLocationsCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'scea:equipments:import';

    /**
     * @var string
     */
    protected $signature = 'scea:equipments:import { --P|path=}';

    /**
     * @var string
     */
    protected $description = 'Import des équipements de la ville ';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    private function importEquipmentsLocations(array $equipments): void
    {
        $bridge = new BridgeContent();

        foreach ($equipments as $equipment) {
            $infos = [
                'type' => 'node',
                'bundle' => 'marker',
                'title' => trim($equipment['nom de l\'équipement']),
                'address' => trim($equipment['adresse postale']) .','. trim($equipment['code postal']),
                'link' => trim($equipment['site internet']),
                'external_image' => $equipment['photo'],
                'phone' => trim($equipment['téléphone']),
                'latitude' => trim($equipment['x']),
                'longitude' => trim($equipment['y']),
            ];

            $bridge->contentInsert('marker', $infos);
        }
    }

    /**
     * import external partner
     */
    public function handle(): void
    {
        $filePath = __DIR__ . '/../../../../../' . env('EQUIPEMENTS_FILE_PATH', 'imports/cartographie.csv');

        /** @var string|null $path */
        $path = $this->option('path');

        if ($path) {
            $filePath = $path;
        }

        $equipments = CsvImporter::getRecords($filePath);
        $this->importEquipmentsLocations($equipments);
    }
}
