<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldSiteToUsers extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();
        $this->bootUp(__FILE__);
        $this->migrateContent('site');
        $this->finishUp();

        $bridge->contentTypeDeleteField('users', 'users', 'location');
        $bridge->contentTypeCreateOrUpdateField('users', 'site', [
            'name' => 'site',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Site',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['site'],
                'cardinality' => -1,
            ],
        ], 3);
    }

    public function down(): void
    {
    }
}
