<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddExternalImageFieldToMarker extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField(
            'marker',
            'external_image',
            [
                'name' => 'external_image',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'URL de l\'image externe',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 10,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
