<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateProjectContentTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'mobile');

        $this->migrateContent('folders');
        $this->migrateContent('documents');
        $this->migrateContent('tools_categories');
        $this->migrateContent('tools');
        $this->migrateContent('departments');
        $this->migrateContent('services');
        $this->migrateContent('users');
        $this->migrateContent('custom');
        $this->migrateContent('pages');
        $this->migrateContent('news_categories');
        $this->migrateContent('news');
        $this->migrateContent('events_categories');
        $this->migrateContent('events');
        $this->migrateContent('flash_news');
        $this->migrateContent('spaces');
        $this->migrateContent('simplified_spaces');
        $this->migrateContent('grouping_pages');
        $this->migrateContent('space_pages');
        $this->migrateContent('marker');
        $this->migrateContent('offers_categories');
        $this->migrateContent('localisations');
        $this->migrateContent('offers');

        $this->finishUp();
    }
}
