import SpacePage from '../pages/spaces/SpacePage'
import TabSpacePage from '../pages/spaces/TabSpacePage'

import ProjectPage from '../pages/projects/ProjectPage'

import { fetchSpace } from '../components/spaces/fetch'
import { fetchProject } from '../components/projects/fetch'

import { withFetch } from 'inside-collection/hocs'

import { CONTENTS } from '@inside-ged/constants/default-contents'
const folderContents = CONTENTS()

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      folderTypes: {
        ...folderContents.folders,
        filters: {
          'status:eq': 1,
          sort: 'weight:asc'
        },
        fields: [...folderContents.folders.fields]
      }
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/users/DirectoryPage')
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'SpacesListingPage',
    component: () => import('../pages/spaces/SpacesListingPage'),
    path: '/espaces'
  },
  {
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace),
    path: '/espaces/:slug'
  },
  {
    name: 'TabSpacePage',
    component: withFetch(TabSpacePage, { size: 'xxl', watch: true })(
      fetchSpace
    ),
    path: '/espaces/:slug/page'
  },
  {
    name: 'ProjectsListingPage',
    component: () => import('../pages/projects/ProjectsListingPage'),
    path: '/projets'
  },
  {
    name: 'ProjectPage',
    component: withFetch(ProjectPage, { size: 'xxl', watch: true })(
      fetchProject
    ),
    path: '/projets/:slug'
  },
  {
    name: 'MapPage',
    meta: { disabled: false },
    props: {
      extraFields: [{ services: ['uuid', 'title'] }],
      extraFilters: [
        {
          modelName: 'services',
          type: 'selectbox',
          fetch: true,
          reference: 'services',
          fields: ['uuid', 'title'],
          filters: { status: 1, sort: 'title:asc' },
          objectValueKey: 'uuid',
          objectLabelKey: 'title',
          label: 'maps.LISTING.filters.services'
        }
      ]
    }
  }
]
