import { markRaw } from 'vue'
import { IconText } from 'inside-collection/atoms'

export default {
  'inside-events': {
    bookmarkEnabled: true,
    showBookmarks: true,
    calendarImportEnabled: true
  },
  'inside-ged': {
    useBookmarks: true
  },
  'inside-jobs': {
    modalName: 'job-offers',
    cardOverrides: (data, { addItemAfter }) => {
      addItemAfter('contract', {
        id: 'location',
        tag: markRaw(IconText),
        data: { icon: 'address' },
        value: data.locations.title
      })
    },
    extraFields: [
      'color',
      { contracts_types: ['uuid', 'title'] },
      { locations: ['uuid', 'title'] },
      { services: ['uuid', 'title'] }
    ],
    categoriesFields: [
      {
        services: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      },
      {
        locations: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      }
    ]
  },
  'inside-news': {
    bookmarkEnabled: true
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' }
      ]
    },
    shortcuts: {
      max: 6
    }
  }
}
