import { http } from '@inside-library/helpers/Http'

const fetchProject = async ({ $route }) => {
  try {
    const { data } = await http.get('content/projects', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'admin',
        'content_type',
        'description',
        'information',
        {
          directions: ['uuid', 'title']
        },
        {
          projects_statuses: ['uuid', 'title', 'color']
        },
        {
          users: [
            'uuid',
            'firstname',
            'lastname',
            'image',
            'function',
            'phone',
            'mobile_phone'
          ]
        },
        {
          projects_folders: {
            fields: ['uuid', 'title'],
            filters: {
              'status:eq': 1,
              sort: 'published_at:desc',
              reverse: true
            }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchProject }
