import { http } from '@inside-library/helpers/Http'

export default {
  contractsTypes: {
    add: () => ({
      name: 'JobsListingPage'
    }),
    delete: () => ({
      name: 'JobsListingPage'
    })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  projects: {
    add: ({ data }) => ({
      name: 'ProjectPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  projectsStatuses: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            'slug',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'TabSpacePage',
        params: {
          slug: pagesCategories[0].spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'TabSpacePage',
        params: {
          slug: pagesCategories[0].spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'TabSpacePage',
          params: {
            slug: pagesCategories[0].spaces.slug[0]
          }
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'slug',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'TabSpacePage',
        params: {
          slug: spacesPages[0].pages_categories.spaces.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'TabSpacePage',
        params: {
          slug: spacesPages[0].pages_categories.spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'TabSpacePage',
          params: {
            slug: spacesPages[0].pages_categories.spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  projectsDocuments: {
    add: async ({ data }) => {
      try {
        const { data: project } = await http.get('content/projects_documents', {
          fields: [
            'uuid',
            'title',
            { projects_folders: ['uuid', { projects: ['uuid', 'slug'] }] }
          ],
          filters: { 'uuid:eq': data.uuid }
        })

        return {
          name: 'ProjectPage',
          params: {
            slug: project[0].projects_folders.projects.slug[0]
          },
          query: {
            folder: project[0].projects_folders.uuid
          }
        }
      } catch (err) {
        return {
          name: 'ProjectsListingPage'
        }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data: project } = await http.get('content/projects_documents', {
          fields: [
            'uuid',
            { projects_folders: ['uuid', { projects: ['uuid', 'slug'] }] }
          ],
          filters: { 'status:eq': 1, 'uuid:eq': uuid }
        })

        return {
          name: 'ProjectPage',
          params: {
            slug: project[0].projects_folders.projects.slug[0]
          }
        }
      } catch (err) {
        return {
          name: 'ProjectsListingPage'
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: projectDoc } = await http.get(
        'content/projects_documents',
        {
          fields: [
            'uuid',
            'title',
            {
              projects_folders: [
                'uuid',
                'title',
                {
                  projects: {
                    fields: ['uuid', 'title', 'slug']
                  }
                }
              ]
            }
          ],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'ProjectPage',
          params: {
            slug: projectDoc[0].projects_folders.projects.slug[0]
          },
          query: { folder: projectDoc[0].projects_folders.uuid }
        }
      }
    }
  },
  projectsFolders: {
    add: async ({ data }) => {
      try {
        const { data: project } = await http.get('content/projects_folders', {
          fields: [
            'uuid',
            'title',
            { projects_folders: ['uuid', { projects: ['uuid', 'slug'] }] },
            { projects: ['uuid', 'slug'] }
          ],
          filters: { 'uuid:eq': data.uuid }
        })

        if (project.projects_folders) {
          const { data: projectFolder } = await http.get(
            'content/projects_folders',
            {
              fields: [
                'uuid',
                'title',
                {
                  projects: ['uuid', 'title', 'slug']
                }
              ],
              filters: { 'uuid:eq': project.projects_folders.uuid }
            }
          )

          return {
            name: 'ProjectPage',
            params: { slug: projectFolder[0].projects.slug[0] }
          }
        }

        if (project[0].projects) {
          const { data: projectData } = await http.get('content/projects', {
            fields: ['uuid', 'title', 'slug'],
            filters: { 'uuid:eq': project[0].projects.uuid }
          })

          return {
            name: 'ProjectPage',
            params: { slug: projectData[0].slug[0] }
          }
        }
      } catch (err) {
        return {
          name: 'ProjectsListingPage'
        }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/projects_folders', {
          fields: ['uuid', { projects: ['uuid', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': uuid }
        })

        return {
          name: 'ProjectPage',
          params: {
            slug: data[0].projects.slug[0]
          }
        }
      } catch (err) {
        return {
          name: 'ProjectsListingPage'
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: projectDoc } = await http.get('content/projects_folders', {
        fields: [
          'uuid',
          'title',

          {
            projects: {
              fields: ['uuid', 'title', 'slug']
            }
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'ProjectPage',
          params: {
            slug: projectDoc[0].projects.slug[0]
          },
          query: { folder: data.uuid }
        }
      }
    }
  },
  jobsOffers: {
    add: () => ({ name: 'JobsListingPage' }),
    delete: () => ({ name: 'JobsListingPage' }),
    globalSearch: ({ data, vm }) => ({
      action: () => {
        vm.triggerModal(
          'job-offers',
          'fetch',
          {
            item: data,
            contentType: data.contentType
          },
          { layout: 'right', size: 'm', transition: 'fadeInLeft' }
        )
      }
    })
  }
}
