export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'function',
      'image',
      'phone',
      'email',
      'mobile_phone',
      'skills',
      'verbal_languages',
      'linkedin_link',
      'twitter_link',
      { directions: ['uuid', 'title'] },
      { departments: ['uuid', 'title'] },
      { services: ['uuid', 'title'] },
      { locations: ['uuid', 'title'] },
      {
        manager: [
          'uuid',
          'lastname',
          'firstname',
          'image',
          'mobile_phone',
          'phone',
          'function'
        ]
      }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  projects_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  jobs_offers: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'color',
      'start_date',
      { contracts_types: ['uuid', 'title'] },
      { services: ['uuid', 'title'] },
      { locations: ['uuid', 'title'] }
    ]
  },
  marker: {
    modalFields: ['uuid', 'title', 'image', 'content', 'address']
  },
  modals: {
    modalFields: ['uuid', 'title', 'content', 'first_connection']
  }
}
