<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'spaces',
            fieldName: 'image',
            options: [
                'name' => 'Image',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Image',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: 1
        );
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'jobs_offers',
            fieldName: 'start_date',
            options: [
                'name' => 'start_date',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 0,
                'title' => [
                    'fr' => 'Date de début',
                ],
                'widget' => [
                    'type' => BridgeContentType::TIMESTAMP_WIDGET,
                    'settings' => [],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::TIMESTAMP_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            weight: 3
        );
        $this->finishUp();
    }
}
