<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

class SeedCustoms extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');

        $customs = collect([
            [
                'title' => 'Actualités',
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage',
            ],
            [
                'title' => 'Évènements',
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage',
            ],
            [
                'title' => 'Annuaire',
                'custom_slug' => 'directory',
                'redirection_page' => 'DirectoryPage',
            ],
            [
                'title' => 'Organigramme',
                'introduction' => 'Retrouvez l’organisation du lorem ipsum dolor sit amet',
                'custom_slug' => 'organizational-charts',
                'redirection_page' => 'OrganizationsListingPage',
            ],
            [
                'title' => 'Bibliothèque de ressources',
                'introduction' => 'Retrouvez tous les documents, photos, fiches pratiques...',
                'custom_slug' => 'ged',
                'redirection_page' => 'GedPage',
            ],
            [
                'title' => 'Mobilité interne',
                'introduction' => "Retrouvez toutes les offres d'emploi du groupe. Que ce soit pour de la mobilité interne ou pour de la cooptation, n'hésitez pas à les consulter régulièrement !",
                'custom_slug' => 'jobs',
                'redirection_page' => 'JobsListingPage',
            ],
            [
                'title' => 'Projets',
                'introduction' => 'Retrouvez tous les projets',
                'custom_slug' => 'projects',
                'redirection_page' => 'ProjectsListingPage',
            ],
            [
                'title' => 'Outils',
                'custom_slug' => 'tools',
                'redirection_page' => 'ToolsPage',
            ],
            [
                'title' => 'Implantations',
                'introduction' => 'Nous sommes présents sur plusieurs lieux. Cliquez sur chaque point pour en découvrir les spécificités.',
                'custom_slug' => 'map',
                'redirection_page' => 'MapPage',
            ],
        ]);

        $bridge = new BridgeContent();

        $customs->each(function (array $custom) use ($bridge) {
            $uuid = Custom::where('title', $custom['title'])->first()?->uuid;

            if ($uuid === null) {
                $bridge->contentInsert('custom', $custom);
                return;
            }

            $custom['uuid'] = $uuid;
            $bridge->contentUpdate('custom', $custom);
        });
    }
}
