<?php

use Adldap\Models\Entry;

return [
    'sync_attributes' => [
        'email' => 'mail',
        'name' => 'userprincipalname',
        'firstname' => 'givenname',
        'lastname' => 'sn',
        'phone' => 'telephonenumber',
        'mobile_phone' => 'homephone',
        'function' => 'title',
        'departments' => fn (Entry $user) => reference('departments')->identifiedBy('code')->from($user->getAttribute('division')[0])->get(),
        'directions' => fn (Entry $user) => reference('directions')->identifiedBy('code')->from($user->getAttribute('department')[0])->get(),
        'services' => fn (Entry $user) => reference('services')->identifiedBy('code')->from($user->getAttribute('physicaldeliveryofficename')[0])->get(),
        'manager' => fn (Entry $user) => reference('users')->identifiedBy('name')->from($user->getAttribute('distinguishednamemanager')[0])->withoutCreation()->get(),
        'is_maintenance' => fn (Entry $user) => false,
        'status' => fn (Entry $user) => true
    ]
];
