<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Departments;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

final class AddCodeToReferences2 extends Migration
{
    private function createField(string $type): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField($type, 'code', [
                'name' => 'code',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Référence d\'import',
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ], 1);
    }
    public function up(): void
    {
        $this->createField('directions');
        $this->createField('services');

        Artisan::call('models:rebuild');
    }
}
