<?php

use Adldap\Models\Entry;

return [
    'postfilter' => function ($users) {
        $mapping = $users->pluck('userprincipalname.0', 'distinguishedname.0');

        return $users->map(function (Entry $user) use ($mapping) {
            $user->setAttribute('distinguishednamemanager', $mapping->get($user->getAttribute('manager')[0], null));

            return $user;
        });
    }
];
