import SpacesPage from '../pages/SpacesPage'

import { fetchSpacesPage } from '../fetch'
import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: { filtersInput: 'selectbox' }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false },
    props: {
      commentsEnabled: false
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/DirectoryPage')
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'SpacesPage',
    path: '/espace/:slug/pages',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage),
    meta: { content: 'spaces' }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'RegisterPage',
    path: '/inscription',
    component: () => import('../pages/register/RegisterPage'),
    meta: {
      logout: true,
      requiresAuth: false
    }
  },
  {
    name: 'RegisterExplainPage',
    path: '/explication-inscription',
    component: () => import('../pages/register/RegisterExplainPage'),
    meta: {
      logout: true,
      requiresAuth: false
    }
  },
  {
    name: 'AdminRegistrationsPage',
    path: '/settings/inscriptions',
    component: () => import('../pages/admin/AdminRegistrationsPage'),
    meta: { permissionKey: 'rhlh_users' }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminDeveloperToolsAuditPage',
    meta: {
      permissionKey: 'system', disabled: true
    }
  }
]
