<?php

namespace Inside\RHLH\Providers;

use Illuminate\Container\Container;
use Inside\RHLH\Console\Commands\RegisterRhlhUsersFromCSV;
use Inside\RHLH\Observers\UsersObserver;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Inside\Content\Models\Contents\Users;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * RHLH Service provider.
 *
 * @category Class
 * @package  Inside\\RHLH\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    public function boot(): void
    {
        if (class_exists(Users::class)) {
            Users::observe(UsersObserver::class);
        }
    }

    public function register(): void
    {
        $this->app->singleton(
            abstract: 'command.rhlh.register',
            concrete: fn (Container $app) => new RegisterRhlhUsersFromCSV()
        );

        $this->commands('command.rhlh.register');

        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/authentication.php', 'authentication');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeConfigTo(__DIR__.'/../../config/authorized.php', 'authorized');
            $this->mergeConfigTo(__DIR__.'/../../config/registration_number.php', 'registration_number');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface $exception) {
        }
    }
}
