<?php

namespace Inside\RHLH\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Lang;
use Inside\Content\Models\Contents\Functions;
use Inside\Content\Models\Contents\Users as UserContent;

class PendingAccount extends Mailable
{
    use Queueable;
    use SerializesModels;

    protected UserContent $user;

    public function __construct(UserContent $user)
    {
        $this->user = $user;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build(): self
    {
        $content = explode("\n", Lang::get('registration.mail.pending.content', [
            'data' => implode("\n", [
                'Prénom : ' . $this->user->firstname,
                'Nom : ' . $this->user->lastname,
                'Matricule : ' . $this->user->registration_number,
            ])
        ]));

        return $this->markdown('emails.registration')
            ->subject(Lang::get('registration.mail.pending.subject'))
            ->with([
                'lines' => $content,
                'actionUrl' => env('APP_URL') . '/settings/inscriptions?user=' . $this->user->uuid,
                'actionText' => Lang::get('registration.mail.pending.button'),
            ]);
    }
}
