<?php

namespace Inside\RHLH\Console\Commands;

use Illuminate\Support\Facades\File;
use Inside\Console\Command;
use Inside\RHLH\Actions\ImportNewRegistrationNumbersFromCsv;

class RegisterRhlhUsersFromCSV extends Command
{
    protected $signature = 'rhlh:register';

    protected $description = 'Import new registration numbers';

    public function handle(): void
    {
        $this->alert('Importing new registration numbers.');

        $path = env("RHLH_USERS_PATH", storage_path('../imports/import.csv'));

        if (! File::exists($path)) {
            $this->error('Any CSV to import, process stopped.');

            return;
        }

        $action = new ImportNewRegistrationNumbersFromCsv();
        $result = $action->register($path);

        $this->info("Registration numbers imported: {$result['imported']}");
        $this->warn("Registration numbers rejected: {$result['rejected']}");
    }
}
