<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AlterUserRegistrationFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdateField(
            type: 'users',
            fieldName: 'registration_status',
            options: [
                'name' => 'registration_status',
                'type' => BridgeContentType::LIST_STRING_FIELD,
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => true,
                'required' => false,
                'weight' => 9,
                'title' => [
                    'fr' => 'Statut d\'inscription',
                ],
                'settings' => [
                    'allowed_values' => [
                        'pending' => [
                            'fr' => 'En attente',
                        ],
                        'accepted' => [
                            'fr' => 'Accepté',
                        ],
                        'declined' => [
                            'fr' => 'Refusé',
                        ],
                    ],
                ],
                'widget' => [
                    'hidden' => true,
                ],
            ]
        );
    }
}
