<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\User\Models\User;
use Inside\Host\Bridge\BridgeContent;
use Illuminate\Support\Collection;

class RecreateRhlhUsersTable extends Migration
{
    public function up(): void
    {
        Schema::dropIfExists('rhlh_users');

        $bridge = new BridgeContent();
        while (User::where('provider_type', 'csv')->count()) {
            User::query()
                ->where('provider_type', 'csv')
                ->limit(50)
                ->pluck('uuid')
                ->each(fn ($uuid) => $bridge->contentDelete('users', $uuid));
        }

        Schema::create('rhlh_registration_numbers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('registration_number')->unique();
            $table->string('manager_email');
            $table->boolean('is_manager');
            $table->date('seniority_date');
            $table->date('expiration_date')->nullable();
        });

        if (User::where('email', 'keepintouch@louvre-hotels.com')->doesntExist()) {
            $bridge->contentInsert('users', [
                'email' => config('registration_number.super_manager'),
                'name' => 'Keep In Touch',
                'firstname' => 'Keep',
                'lastname' => 'Touch',
                'is_maintenance' => true,
                'is_manager' => true,
                'registration_status' => true,
                'send_mail' => false,
                'status' => true,
            ]);
        }
    }
}
