<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddWeightOnTabbedPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = ['spaces_pages', 'pages_categories'];

        foreach ($contentTypes as $contentType) {
            $bridge->contentTypeCreateOrUpdateField($contentType, 'weight', [
                'name' => 'weight',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Ordre d\'affichage',
                ],
                'description' => [
                    'fr' => 'Le chiffre le plus bas remonte en 1er',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => 0,
            ]);
        }
    }

    public function down(): void
    {
    }
}
