<?php

use Inside\Content\Models\Contents\Users;

return [
    'types' => [
        'news' => [
            'category' => 'news_categories',
            'comments' => false,
            'likes'    => true,
        ],
        'documents' => [
            'category' => 'folders',
            'comments' => false,
            'likes'    => false,
        ]
    ],
    'export' => [
        'contents' => [
            'headers'    => [
                'uuid'         => 'UUID',
                'content_type' => 'Content type',
                'title'        => 'Title',
                'edit'         => 'Edit link',
            ],
            'presenters' => [
                'edit' => function ($value, $model) {
                    return env('APP_URL') . '/edit/' . class_to_type($model) . '/' . $model->uuid;
                },
            ],
        ],
        'users'    => [
            'headers' => [
                'email'    => 'Mail address',
                'full_name' => 'Full name'
            ]
        ],
        'user_visits' => [
            'headers' => [
                'email'    => 'Mail address',
                'full_name' => 'Full name',
            ],
        ],
        'authentication' => [
            'headers' => [
            ],
        ]
    ],
];
