<?php

use Illuminate\Support\Facades\Lang;
use Inside\Authentication\Exceptions\UserNotActiveException;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Users;

return [
    'login_rules' => [
        function (User $user) {
            $userContent = Users::query()->find($user->uuid);

            if (in_array($userContent->registration_status, ['pending', 'declined'])) {
                throw new UserNotActiveException(Lang::get('auth.userIsNotActive'));
            }
        }
    ]
];
