<?php

namespace Inside\RHLH\Observers;

use Inside\Content\Models\Contents\Users as UserContent;
use Inside\RHLH\Actions\MailAcceptedUser;
use Inside\RHLH\Actions\MailDeclinedUser;
use Inside\RHLH\Actions\NotifyManagerToReviewUser;
use Inside\User\Models\User;

class UsersObserver
{
    /**
     * Handle the User "created" event.
     *
     * @param  UserContent  $user
     * @return void
     */
    public function created(UserContent $user): void
    {
        if ($user->registration_status !== 'pending') {
            return;
        }

        (new NotifyManagerToReviewUser())($user);
    }

    /**
     * Handle the User "updated" event.
     *
     * @param  UserContent  $user
     * @return void
     */
    public function updating(UserContent $user): void
    {
        if (! $user->isDirty('registration_status') && $user->getOriginal('registration_status') === "pending") {
            return;
        }

        /** @var ?User $model */
        $model = User::find($user->uuid);

        if (! $model) {
            return;
        }

        $action = $user->registration_status === 'accepted'
            ? new MailAcceptedUser()
            : new MailDeclinedUser();

        $action($model);
    }
}
