<?php

namespace Inside\RHLH\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Lang;

class RegistrationDeclined extends Mailable
{
    use Queueable;
    use SerializesModels;

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build(): self
    {
        return $this
            ->markdown('emails.registration_declined')
            ->subject(Lang::get('registration.mail.declined.subject'))
            ->with(['content' => Lang::get('registration.mail.declined.content')]);
    }
}
